
#ifndef _1_KMNG_EXT_ATP_IMPORT_EXPORT_h_H
#define _1_KMNG_EXT_ATP_IMPORT_EXPORT_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "DX_VOS_BaseTypes.h"
#include "KMNG_SEP_ATP_Defines.h"
#include "KMNG_Defs.h"
#include "CRYS_AES.h"
#include "CRYS_DES.h"
#include "CRYS_HASH.h"
#include "CRYS_RSA_Types.h"


#ifdef __cplusplus
extern "C"
{
#endif


	/*
	*  Object %name    : %
	*  State           :  %state%
	*  Creation date   :  Sun Jul 22 10:17:10 2007
	*  Last modified   :  %modify_time%
	*/
	/** @file 
	*  \brief This file includes the KMNG create, import and export keys 
	*          ATP tests						 
	*
	*  \version KMNG_SEP_ATP_ImportExportKeys.h#1:csrc:1
	*  \author Annag
	*  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
	*           All Rights reserved
	*/


  /************************ Defines *******************************/

  /************************ Enums *********************************/
  /************************ Typedefs  *****************************/
  /************************ Structs  ******************************/


/************************ Global Data ***************************/
/************************ Public Variables **********************/
/************************ Public Functions **********************/

/***********************************************************************
* Function Name:                                                           
*  SEP_KMNG_ATP_Ext_ImportExportSymKeys         
* 
* Inputs:
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for create, import, export of the symmetric keys.
* Algorithm:       
* 1. Create a master key
* 2. Import symmetric key
* 3. Export symmetric key                                            
* 4. Verify exported key data 
**************************************************************************************/                                
DxError_t SEP_KMNG_ATP_Ext_ImportExportSymKeys( void );

/***********************************************************************
* Function Name:                                                           
*  SEP_KMNG_ATP_Ext_ImportExportRSAKeys         
* 
* Inputs:
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for create, import, export of the symmetric keys.
* Algorithm:       
* 1. Create a master key
* 2. Import RSA key
* 3. Export RSA key                                            
* 4. Verify exported RSA key data 
**************************************************************************************/                                
DxError_t SEP_KMNG_ATP_Ext_ImportExportRSAKeys( void );
#ifdef __cplusplus
}
#endif

#endif
